<?php

/**
 * This class adds the options with the related callbacks and validations.
 */
class Dalt_Menu_Options {

	public function __construct( $shared ) {

		//assign an instance of the plugin info
		$this->shared = $shared;

	}

	public function register_options() {

		//section general ----------------------------------------------------------
		add_settings_section(
			'dalt_general_settings_section',
			null,
			null,
			'dalt_general_options'
		);

		add_settings_field(
			'tables_menu_capability',
			esc_html__('Tables Menu Capability', 'dalt'),
			array($this, 'tables_menu_capability_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_tables_menu_capability',
			array($this, 'tables_menu_capability_validation')
		);

		add_settings_field(
			'import_menu_capability',
			esc_html__('Import Menu Capability', 'dalt'),
			array($this, 'import_menu_capability_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_import_menu_capability',
			array($this, 'import_menu_capability_validation')
		);

		add_settings_field(
			'export_menu_capability',
			esc_html__('Export Menu Capability', 'dalt'),
			array($this, 'export_menu_capability_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_export_menu_capability',
			array($this, 'export_menu_capability_validation')
		);

		add_settings_field(
			'general_javascript_file_url',
			esc_html__('General JavaScript File URL', 'dalt'),
			array($this, 'general_javascript_file_url_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_general_javascript_file_url',
			array($this, 'general_javascript_file_url_validation')
		);

		add_settings_field(
			'general_styleshett_file_url',
			esc_html__('General Stylesheet File URL', 'dalt'),
			array($this, 'general_stylesheet_file_url_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_general_stylesheet_file_url',
			array($this, 'general_stylesheet_file_url_validation')
		);

		add_settings_field(
			'tablesorter_library_url',
			esc_html__('Tablesorter Library URL', 'dalt'),
			array($this, 'tablesorter_library_url_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_tablesorter_library_url',
			array($this, 'tablesorter_library_url_validation')
		);

		add_settings_field(
			'load_google_font_1',
			esc_html__('Load Google Font 1', 'dalt'),
			array($this, 'load_google_font_1_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_load_google_font_1',
			array($this, 'load_google_font_1_validation')
		);

		add_settings_field(
			'load_google_font_2',
			esc_html__('Load Google Font 2', 'dalt'),
			array($this, 'load_google_font_2_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_load_google_font_2',
			array($this, 'load_google_font_2_validation')
		);

		add_settings_field(
			'max_execution_time',
			esc_html__('Max Execution Time', 'dalt'),
			array($this, 'max_execution_time_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_max_execution_time',
			array($this, 'max_execution_time_validation')
		);

		add_settings_field(
			'memory_limit',
			esc_html__('Memory Limit', 'dalt'),
			array($this, 'memory_limit_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_memory_limit',
			array($this, 'memory_limit_validation')
		);

		add_settings_field(
			'limit_shortcode_parsing',
			esc_html__('Limit Shortcode Parsing', 'dalt'),
			array($this, 'limit_shortcode_parsing_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_limit_shortcode_parsing',
			array($this, 'limit_shortcode_parsing_validation')
		);

		add_settings_field(
			'verify_single_shortcode',
			esc_html__('Verify Single Shortcode', 'dalt'),
			array($this, 'verify_single_shortcode_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_verify_single_shortcode',
			array($this, 'verify_single_shortcode_validation')
		);

		add_settings_field(
			'widget_text_shortcode',
			esc_html__('Shortcode in Text Widget', 'dalt'),
			array($this, 'widget_text_shortcode_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_widget_text_shortcode',
			array($this, 'widget_text_shortcode_validation')
		);

		add_settings_field(
			'apply_kses',
			esc_html__('Apply kses', 'dalt'),
			array($this, 'apply_kses_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_apply_kses',
			array($this, 'apply_kses_validation')
		);

		add_settings_field(
			'kses_allowed_html_tags',
			esc_html__('kses Allowed HTML Tags', 'dalt'),
			array($this, 'kses_allowed_html_tags_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_kses_allowed_html_tags',
			array($this, 'kses_allowed_html_tags_validation')
		);

		add_settings_field(
			'kses_allowed_protocols',
			esc_html__('kses Allowed Protocols', 'dalt'),
			array($this, 'kses_allowed_protocols_callback'),
			'dalt_general_options',
			'dalt_general_settings_section'
		);

		register_setting(
			'dalt_general_options',
			'dalt_kses_allowed_protocols',
			array($this, 'kses_allowed_protocols_validation')
		);

		//section capabilities -----------------------------------------------------------------------------------------
		add_settings_section(
			'dalt_cell_properties_settings_section',
			null,
			null,
			'dalt_cell_properties_options'
		);

		add_settings_field(
			'enable_text_color_cell_property',
			esc_html__('Text Color', 'dalt'),
			array($this, 'enable_text_color_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_text_color_cell_property',
			array($this, 'enable_text_color_cell_property_validation')
		);

		add_settings_field(
			'enable_background_color_cell_property',
			esc_html__('Background Color', 'dalt'),
			array($this, 'enable_background_color_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_background_color_cell_property',
			array($this, 'enable_background_color_cell_property_validation')
		);

		add_settings_field(
			'enable_alignment_cell_property',
			esc_html__('Alignment', 'dalt'),
			array($this, 'enable_alignment_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_alignment_cell_property',
			array($this, 'enable_alignment_cell_property_validation')
		);

		add_settings_field(
			'enable_font_weight_cell_property',
			esc_html__('Font Weight', 'dalt'),
			array($this, 'enable_font_weight_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_font_weight_color_cell_property',
			array($this, 'enable_font_weight_cell_property_validation')
		);

		add_settings_field(
			'enable_font_style_cell_property',
			esc_html__('Font Style', 'dalt'),
			array($this, 'enable_font_style_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_font_style_cell_property',
			array($this, 'enable_font_style_cell_property_validation')
		);

		add_settings_field(
			'enable_link_cell_property',
			esc_html__('Link', 'dalt'),
			array($this, 'enable_link_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_link_cell_property',
			array($this, 'enable_link_cell_property_validation')
		);

		add_settings_field(
			'enable_link_color_cell_property',
			esc_html__('Link Color', 'dalt'),
			array($this, 'enable_link_color_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_link_color_cell_property',
			array($this, 'enable_link_color_cell_property_validation')
		);

		add_settings_field(
			'enable_open_link_new_tab_cell_property',
			esc_html__('Open Link New Tab', 'dalt'),
			array($this, 'enable_open_link_new_tab_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_open_link_new_tab_cell_property',
			array($this, 'enable_text_color_cell_property_validation')
		);

		add_settings_field(
			'enable_image_left_cell_property',
			esc_html__('Image Left', 'dalt'),
			array($this, 'enable_image_left_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_image_left_cell_property',
			array($this, 'enable_image_left_cell_property_validation')
		);

		add_settings_field(
			'enable_image_left_link_cell_property',
			esc_html__('Image Left Link', 'dalt'),
			array($this, 'enable_image_left_link_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_image_left_link_cell_property',
			array($this, 'enable_image_left_link_cell_property_validation')
		);

		add_settings_field(
			'enable_image_left_open_link_new_tab_cell_property',
			esc_html__('Image Left Open Link New Tab', 'dalt'),
			array($this, 'enable_image_left_open_link_new_tab_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_image_left_open_link_new_tab_cell_property',
			array($this, 'enable_image_left_open_link_new_tab_cell_property_validation')
		);

		add_settings_field(
			'enable_image_left_cell_property',
			esc_html__('Image Left', 'dalt'),
			array($this, 'enable_image_left_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_image_left_cell_property',
			array($this, 'enable_image_left_cell_property_validation')
		);

		add_settings_field(
			'enable_image_left_link_cell_property',
			esc_html__('Image Left Link', 'dalt'),
			array($this, 'enable_image_left_link_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_image_left_link_cell_property',
			array($this, 'enable_image_left_link_cell_property_validation')
		);

		add_settings_field(
			'enable_image_left_open_link_new_tab_cell_property',
			esc_html__('Image Left Open Link New Tab', 'dalt'),
			array($this, 'enable_image_left_open_link_new_tab_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_image_left_open_link_new_tab_cell_property',
			array($this, 'enable_image_left_open_link_new_tab_cell_property_validation')
		);

		add_settings_field(
			'enable_image_right_cell_property',
			esc_html__('Image Right', 'dalt'),
			array($this, 'enable_image_right_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_image_right_cell_property',
			array($this, 'enable_image_right_cell_property_validation')
		);

		add_settings_field(
			'enable_image_right_link_cell_property',
			esc_html__('Image Right Link', 'dalt'),
			array($this, 'enable_image_right_link_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_image_right_link_cell_property',
			array($this, 'enable_image_right_link_cell_property_validation')
		);

		add_settings_field(
			'enable_image_right_open_link_new_tab_cell_property',
			esc_html__('Image Right Open Link New Tab', 'dalt'),
			array($this, 'enable_image_right_open_link_new_tab_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_image_right_open_link_new_tab_cell_property',
			array($this, 'enable_image_right_open_link_new_tab_cell_property_validation')
		);

		add_settings_field(
			'enable_formula_data_cell_property',
			esc_html__('Formula Data', 'dalt'),
			array($this, 'enable_formula_data_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_formula_data_cell_property',
			array($this, 'enable_formula_data_cell_property_validation')
		);

		add_settings_field(
			'enable_html_content_cell_property',
			esc_html__('HTML Content', 'dalt'),
			array($this, 'enable_html_content_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_html_content_cell_property',
			array($this, 'enable_html_content_cell_property_validation')
		);

		add_settings_field(
			'enable_row_slots_cell_property',
			esc_html__('Row Slots', 'dalt'),
			array($this, 'enable_row_slots_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_row_slots_cell_property',
			array($this, 'enable_row_slots_cell_property_validation')
		);

		add_settings_field(
			'enable_column_slots_cell_property',
			esc_html__('Column Slots', 'dalt'),
			array($this, 'enable_column_slots_cell_property_callback'),
			'dalt_cell_properties_options',
			'dalt_cell_properties_settings_section'
		);

		register_setting(
			'dalt_cell_properties_options',
			'dalt_enable_column_slots_cell_property',
			array($this, 'enable_column_slots_cell_property_validation')
		);

	}

	//General ----------------------------------------------------------------------------------------------------------

	public function tables_menu_capability_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-tables-menu-capability" name="dalt_tables_menu_capability" class="regular-text" value="' . esc_attr(get_option("dalt_tables_menu_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Tables" menu.', 'dalt') . '"></div>';

		echo $html;

	}

	public function tables_menu_capability_validation($input)
	{

		return sanitize_key($input);

	}

	public function import_menu_capability_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-import-menu-capability" name="dalt_import_menu_capability" class="regular-text" value="' . esc_attr(get_option("dalt_import_menu_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Import" menu.', 'dalt') . '"></div>';

		echo $html;

	}

	public function import_menu_capability_validation($input)
	{

		return sanitize_key($input);

	}

	public function export_menu_capability_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-export-menu-capability" name="dalt_export_menu_capability" class="regular-text" value="' . esc_attr(get_option("dalt_export_menu_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Export" menu.', 'dalt') . '"></div>';

		echo $html;

	}

	public function export_menu_capability_validation($input)
	{

		return sanitize_key($input);

	}

	public function general_javascript_file_url_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-general-javascript-file-url" name="dalt_general_javascript_file_url" class="regular-text" value="' . esc_attr(get_option("dalt_general_javascript_file_url")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The URL where the general JavaScript file is located.', 'dalt') . '"></div>';

		echo $html;

	}

	public function general_javascript_file_url_validation($input)
	{

		return esc_url_raw($input);

	}

	public function general_stylesheet_file_url_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-general-stylesheet-file-url" name="dalt_general_stylesheet_file_url" class="regular-text" value="' . esc_attr(get_option("dalt_general_stylesheet_file_url")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The URL where the general Stylesheet file is located.', 'dalt') . '"></div>';

		echo $html;

	}

	public function general_stylesheet_file_url_validation($input)
	{

		return esc_url_raw($input);

	}

	public function tablesorter_library_url_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-tablesorter-library-url" name="dalt_tablesorter_library_url" class="regular-text" value="' . esc_attr(get_option("dalt_tablesorter_library_url")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The URL where the Tablesorter library is located.', 'dalt') . '"></div>';

		echo $html;

	}

	public function tablesorter_library_url_validation($input)
	{

		return esc_url_raw($input);

	}

	public function load_google_font_1_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-load-google-font-1" name="dalt_load_google_font_1" class="regular-text" value="' . esc_attr(get_option("dalt_load_google_font_1")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('Enter the URL of a Google Font.', 'dalt') . '"></div>';

		echo $html;

	}

	public function load_google_font_1_validation($input)
	{

		return esc_url_raw($input);

	}

	public function load_google_font_2_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-load-google-font-2" name="dalt_load_google_font_2" class="regular-text" value="' . esc_attr(get_option("dalt_load_google_font_2")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('Enter the URL of a Google Font.', 'dalt') . '"></div>';

		echo $html;

	}

	public function load_google_font_2_validation($input)
	{

		return esc_url_raw($input);

	}

	public function max_execution_time_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-max-execution-time" name="dalt_max_execution_time" class="regular-text" value="' . esc_attr(get_option("dalt_max_execution_time")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('Please enter a number from 1 to 1000000. This value determines the maximum number of seconds allowed to execute the PHP scripts used by this plugin to alter or display the data of the tables.', 'dalt') . '"></div>';

		echo $html;

	}

	public function max_execution_time_validation($input)
	{

		if (!preg_match($this->shared->digits_regex, $input) or intval($input, 10) < 1 or intval($input, 10) > 1000000) {
			add_settings_error('dalt_max_execution_time', 'dalt_max_execution_time', esc_html__('Please enter a number from 1 to 1000000 in the "Max Execution Time Value" option.', 'dalt'));
			$output = get_option('dalt_max_execution_time');
		} else {
			$output = $input;
		}

		return intval($output, 10);

	}

	public function memory_limit_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-memory-limit" name="dalt_memory_limit" class="regular-text" value="' . esc_attr(get_option("dalt_memory_limit")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('Please enter a number from 1 to 1000000. This value determines the PHP memory limit in megabytes allowed to execute the PHP scripts used by this plugin to alter or display the data of the tables.', 'dalt') . '"></div>';

		echo $html;

	}

	public function memory_limit_validation($input)
	{

		if (!preg_match($this->shared->digits_regex, $input) or intval($input, 10) < 1 or intval($input, 10) > 1000000) {
			add_settings_error('dalt_memory_limit', 'dalt_memory_limit', esc_html__('Please enter a number from 1 to 1000000 in the "Memory Limit Value" option.', 'dalt'));
			$output = get_option('dalt_memory_limit');
		} else {
			$output = $input;
		}

		return intval($output, 10);

	}

	public function limit_shortcode_parsing_callback($args)
	{

		$html = '<select id="dalt-limit-shortcode-parsing" name="dalt_limit_shortcode_parsing" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_limit_shortcode_parsing")), 0, false) . ' value="0">' . esc_html__('No', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_limit_shortcode_parsing")), 1, false) . ' value="1">' . esc_html__('Yes', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the shortcodes generated with this plugin will be parsed only when the full content of single posts and pages is displayed.', 'dalt') . '"></div>';

		echo $html;

	}

	public function limit_shortcode_parsing_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function verify_single_shortcode_callback($args)
	{

		$html = '<select id="dalt-verify-single-shortcode" name="dalt_verify_single_shortcode" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_verify_single_shortcode")), 0, false) . ' value="0">' . esc_html__('No', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_verify_single_shortcode")), 1, false) . ' value="1">' . esc_html__('Yes', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the presence of a single application of the same shortcode is verified.', 'dalt') . '"></div>';

		echo $html;

	}

	public function verify_single_shortcode_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function widget_text_shortcode_callback($args)
	{

		$html = '<select id="dalt-widget-text-shortcode" name="dalt_widget_text_shortcode" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_widget_text_shortcode")), 0, false) . ' value="0">' . esc_html__('No', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_widget_text_shortcode")), 1, false) . ' value="1">' . esc_html__('Yes', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the shortcodes included inside text widgets will be parsed.', 'dalt') . '"></div>';

		echo $html;

	}

	public function widget_text_shortcode_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function apply_kses_callback($args)
	{

		$html = '<select id="dalt-apply-kses" name="dalt_apply_kses" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_apply_kses")), 0, false) . ' value="0">' . esc_html__('No', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_apply_kses")), 1, false) . ' value="1">' . esc_html__('Yes', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With kses enabled only the allowed HTML element names, attribute names and attribute values will be displayed in the output of the "HTML Content" cell property.', 'dalt') . '"></div>';

		echo $html;

	}

	public function apply_kses_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function kses_allowed_html_tags_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-kses-allowed-html-tags" name="dalt_kses_allowed_html_tags" class="regular-text" value="' . esc_attr(get_option("dalt_kses_allowed_html_tags")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('Enter a list of HTML element names allowed by kses, separated by a comma. You can also set which attributes are allowed for each tag by adding the list of attribute names included in square brackets after the HTML element name, for example you can allow in kses the "a" HTML element with the "href" and "title" attributes by using this string "a[href][title]".', 'dalt') . '"></div>';

		echo $html;

	}

	public function kses_allowed_html_tags_validation($input)
	{

		$input = sanitize_text_field($input);

		if (!preg_match('/^(\s*([A-Za-z0-9\[\]]+\s*,\s*)+[A-Za-z0-9\[\]]+\s*|\s*[A-Za-z0-9\[\]]+\s*)$/', $input) and strlen(trim($input)) > 0) {
			add_settings_error('dalt_kses_allowed_html_tags', 'dalt_kses_allowed_html_tags', esc_html__('Please enter a valid value in the "kses Allowed HTML Tags" option.', 'dalt'));
			$output = get_option('dalt_kses_allowed_html_tags');
		} else {
			$output = $input;
		}

		return trim($output);

	}

	public function kses_allowed_protocols_callback($args)
	{

		$html = '<input autocomplete="off" type="text" id="dalt-kses-allowed-protocols" name="dalt_kses_allowed_protocols" class="regular-text" value="' . esc_attr(get_option("dalt_kses_allowed_protocols")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('Enter a list of protocols, separated by a comma. This option determines which protocols are allowed by kses inside HTML links.', 'dalt') . '"></div>';

		echo $html;

	}

	public function kses_allowed_protocols_validation($input)
	{

		$input = sanitize_text_field($input);

		if (!preg_match('/^(\s*([A-Za-z]+\s*,\s*)+[A-Za-z]+\s*|\s*[A-Za-z]+\s*)$/', $input) and strlen(trim($input)) > 0) {
			add_settings_error('dalt_kses_allowed_protocols', 'dalt_kses_allowed_protocols', esc_html__('Please enter a valid value in the "kses Allowed Protocols" option.', 'dalt'));
			$output = get_option('dalt_kses_allowed_protocols');
		} else {
			$output = $input;
		}

		return trim($output);

	}

	//Cell Properties --------------------------------------------------------------------------------------------------

	public function enable_text_color_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-text-color-cell-property" name="dalt_enable_text_color_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_text_color_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_text_color_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Text Color" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_text_color_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_background_color_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-background-color-cell-property" name="dalt_enable_background_color_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_background_color_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_background_color_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr(__('With this option enabled the "Background Color" field will be added in the cell properties.', 'dalt')) . '"></div>';

		echo $html;

	}

	public function enable_background_color_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_alignment_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-alignment-cell-property" name="dalt_enable_alignment_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_alignment_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_alignment_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Alignment" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_alignment_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_font_weight_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-font-weight-cell-property" name="dalt_enable_font_weight_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_font_weight_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_font_weight_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Font Weight" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_font_weight_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_font_style_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-font-style-cell-property" name="dalt_enable_font_style_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_font_style_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_font_style_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Font Style" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_font_style_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_link_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-link-cell-property" name="dalt_enable_link_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_link_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_link_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Link" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_link_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_link_color_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-link-color-cell-property" name="dalt_enable_link_color_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_link_color_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_link_color_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Link Color" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_link_color_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_open_link_new_tab_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-open-link-new-tab-cell-property" name="dalt_enable_open_link_new_tab_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_open_link_new_tab_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_open_link_new_tab_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Open Link New Tab" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_open_link_new_tab_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_image_left_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-image-left-cell-property" name="dalt_enable_image_left_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_left_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_left_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Image Left" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_image_left_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_image_left_link_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-image-left-link-cell-property" name="dalt_enable_image_left_link_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_left_link_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_left_link_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Image Left Link" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_image_left_link_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_image_left_open_link_new_tab_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-image-left-open-link-new-tab-cell-property" name="dalt_enable_image_left_open_link_new_tab_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_left_open_link_new_tab_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_left_open_link_new_tab_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Image Left Open Link New Tab" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_image_left_open_link_new_tab_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_image_right_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-image-right-cell-property" name="dalt_enable_image_right_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_right_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_right_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Image Right" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_image_right_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_image_right_link_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-image-right-link-cell-property" name="dalt_enable_image_right_link_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_right_link_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_right_link_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Image Right Link" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_image_right_link_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_image_right_open_link_new_tab_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-image-right-open-link-new-tab-cell-property" name="dalt_enable_image_right_open_link_new_tab_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_right_open_link_new_tab_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_image_right_open_link_new_tab_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Image Right Open Link New Tab" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_image_right_open_link_new_tab_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_formula_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-formula-cell-property" name="dalt_enable_formula_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_formula_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_formula_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Formula" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_formula_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_formula_data_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-formula-data-cell-property" name="dalt_enable_formula_data_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_formula_data_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_formula_data_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Formula Data" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_formula_data_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_html_content_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-html-content-cell-property" name="dalt_enable_html_content_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_html_content_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_html_content_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "HTML Content" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_html_content_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_row_slots_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-row-slots-cell-property" name="dalt_enable_row_slots_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_row_slots_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_row_slots_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Row Slots" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_row_slots_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

	public function enable_column_slots_cell_property_callback($args)
	{

		$html = '<select id="dalt-enable-column-slots-cell-property" name="dalt_enable_column_slots_cell_property" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_column_slots_cell_property")), 0, false) . ' value="0">' . esc_html__('Disabled', 'dalt') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dalt_enable_column_slots_cell_property")), 1, false) . ' value="1">' . esc_html__('Enabled', 'dalt') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled the "Column Slots" field will be added in the cell properties.', 'dalt') . '"></div>';

		echo $html;

	}

	public function enable_column_slots_cell_property_validation($input)
	{

		return intval($input, 10) == 1 ? '1' : '0';

	}

}